# ctf_backend.py

import subprocess

def execute_command(cmd):
    """
    Executes a shell command and captures stdout/stderr.
    Returns a dictionary with the command string, stdout, and stderr.
    """
    try:
        result = subprocess.run(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)
        return {
            'command': ' '.join(cmd),
            'stdout': result.stdout.strip(),
            'stderr': result.stderr.strip()
        }
    except Exception as e:
        return {
            'command': ' '.join(cmd),
            'stdout': '',
            'stderr': str(e)
        }

def summarize_output(output):
    """
    Naive summarizer for command output.
    You can replace this with NLP-based parsing later.
    """
    lines = output.splitlines()
    important = [line for line in lines if any(keyword in line.lower() for keyword in [
        'warning', 'alert', 'found', 'malware', 'infected', 'unauthorized', 'error', 'password', 'bitcoin', 'decrypt'
    ])]
    
    if not important:
        important = lines[:10]  # fallback to top 10 lines

    return '\n'.join(important)
