export function generateMockPeople(lat: number, lng: number) {
  const radius = 0.01;
  const clusters = 10 + Math.floor(Math.random() * 5); // 10–14 clusters
  const people = [];

  for (let i = 0; i < clusters; i++) {
    const centerLat = lat + (Math.random() - 0.5) * 0.01;
    const centerLng = lng + (Math.random() - 0.5) * 0.01;
    const clusterSize = 70 + Math.floor(Math.random() * 40); // 70–110 people per cluster

    for (let j = 0; j < clusterSize; j++) {
      const angle = Math.random() * 2 * Math.PI;
      const r = Math.random() * radius;

      people.push({
        lat: centerLat + Math.cos(angle) * r,
        lng: centerLng + Math.sin(angle) * r,
        people_count: 1,
        name: `พื้นที่คนเยอะ #${i + 1}`, // 👈 Updated naming
        crowd_level:
          clusterSize >= 100 ? "หนาแน่นมาก" :
          clusterSize >= 50 ? "หนาแน่น" :
          "ปานกลาง",
      });
    }
  }

  return people;
}
